/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.mss;

import ibm.nways.cfgtool.CfgToolContext;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmContext;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel;
import ibm.nways.jdm.eui.BoxDownMsg;
import ibm.nways.jdm.eui.WrongSysOidMsg;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.mib2.SystemGeneralGroup;
import ibm.nways.mss.BladeGraphic;
import ibm.nways.mss.BoxGraphic;
import ibm.nways.mss.CodeLevelMss;
import ibm.nways.mss.eui.ConfigurationFolderGroup;
import ibm.nways.mss.eui.FaultGroup;
import ibm.nways.mss.eui.MssFolderGroup;
import ibm.nways.ras.RAS;
import ibm.nways.rping.eui.RpingBasePanel;
import ibm.nways.telnet.TelnetContext;
import ibm.nways.web.WebContext;
import java.io.Serializable;
import java.util.ResourceBundle;

public class Mss
extends JdmBrowser {
    CodeLevelMss codeLevel = new CodeLevelMss();
    private boolean isBox = false;
    private boolean isSSBlade = false;
    private boolean isV2MSS = false;
    private boolean isBlade = false;
    private boolean isDeviceUp = false;
    private GenModel mssModel;
    private ResourceBundle mssBundle;
    private static final int plat_mss_blade = 3;
    private static final int plat_mss_8210V2 = 25;
    private static final int plat_mss_bladeV2 = 26;
    private NavFieldOverride mssOverrides;
    private NavigationBrowser tree;
    private static final int RASID = 19;
    private static final int RASSUB = 26;
    static final Object[][] mssFieldOverrides = new Object[][]{{"ibm.nways.appletalk.model.Port.Panel.AtportType.access", "read-only"}, {"ibm.nways.appletalk.model.Port.Panel.AtportNetStart.access", "read-only"}, {"ibm.nways.appletalk.model.Port.Panel.AtportNetEnd.access", "read-only"}, {"ibm.nways.appletalk.model.Port.Panel.AtportNetAddress.access", "read-only"}, {"ibm.nways.appletalk.model.Port.Panel.AtportStatus.access", "read-only"}, {"ibm.nways.appletalk.model.Port.Panel.AtportZone.access", "read-only"}, {"ibm.nways.appletalk.model.Port.Panel.AtportIfIndex.access", "read-only"}, {"ibm.nways.appletalk.model.Routing.Panel.RtmpRangeStart.access", "read-only"}, {"ibm.nways.appletalk.model.Routing.Panel.RtmpRangeEnd.access", "read-only"}, {"ibm.nways.appletalk.model.Routing.Panel.RtmpNextHop.access", "read-only"}, {"ibm.nways.appletalk.model.Routing.Panel.RtmpType.access", "read-only"}, {"ibm.nways.appletalk.model.Routing.Panel.RtmpPort.access", "read-only"}, {"ibm.nways.appletalk.model.Routing.Panel.RtmpHops.access", "read-only"}, {"ibm.nways.appletalk.model.Routing.Panel.RtmpState.access", "read-only"}, {"ibm.nways.appletalk.model.Zone.Panel.ZipZoneName.access", "read-only"}, {"ibm.nways.appletalk.model.Zone.Panel.ZipZoneNetStart.access", "read-only"}, {"ibm.nways.appletalk.model.Zone.Panel.ZipZoneNetEnd.access", "read-only"}, {"ibm.nways.appletalk.model.Zone.Panel.ZipZoneState.access", "read-only"}, {"ibm.nways.appletalk.model.Nbp.Panel.NbpObject.access", "read-only"}, {"ibm.nways.appletalk.model.Nbp.Panel.NbpType.access", "read-only"}, {"ibm.nways.appletalk.model.Nbp.Panel.NbpZone.access", "read-only"}, {"ibm.nways.appletalk.model.Nbp.Panel.NbpState.access", "read-only"}, {"ibm.nways.appn.model.SnaLuSessn.Panel.SnaLuSessnAdminState.access", "read-only"}, {"ibm.nways.appn.model.AppcScalars.Panel.AppcCntrlAdminTrace.access", "read-only"}, {"ibm.nways.appn.model.AppcScalars.Panel.AppcCntrlAdminTraceParm.access", "read-only"}, {"ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceMaxVpcs.access", "read-only"}, {"ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceMaxVccs.access", "read-only"}, {"ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceMaxActiveVpiBits.access", "read-only"}, {"ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceMaxActiveVciBits.access", "read-only"}, {"ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceIlmiVpi.access", "read-only"}, {"ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceIlmiVci.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrType.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam1.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam2.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam3.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam4.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam5.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficQoSClass.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVclAdminStatus.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVclReceiveTrafficDescrIndex.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVclTransmitTrafficDescrIndex.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVccAalType.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVccAal5CpcsTransmitSduSize.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVccAal5CpcsReceiveSduSize.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVccAal5EncapsType.access", "read-only"}, {"ibm.nways.bgp.model.Peer.Panel.BgpPeerAdminStatus.access", "read-only"}, {"ibm.nways.bgp.model.Peer.Panel.BgpPeerConnectRetryInterval.access", "read-only"}, {"ibm.nways.bgp.model.Peer.Panel.BgpPeerHoldTimeConfigured.access", "read-only"}, {"ibm.nways.bgp.model.Peer.Panel.BgpPeerKeepAliveConfigured.access", "read-only"}, {"ibm.nways.bgp.model.Peer.Panel.BgpPeerMinASOriginationInterval.access", "read-only"}, {"ibm.nways.bgp.model.Peer.Panel.BgpPeerMinRouteAdvertisementInterval.access", "read-only"}, {"ibm.nways.bridge.model.Ports.Panel.Dot1dStpPortPriority.access", "read-only"}, {"ibm.nways.bridge.model.Ports.Panel.Dot1dStpPortEnable.access", "read-only"}, {"ibm.nways.bridge.model.Ports.Panel.Dot1dStpPortPathCost.access", "read-only"}, {"ibm.nways.bridge.model.Ports.Panel.Dot1dSrPortHopCount.access", "read-only"}, {"ibm.nways.bridge.model.Ports.Panel.Dot1dSrPortLocalSegment.access", "read-only"}, {"ibm.nways.bridge.model.Ports.Panel.Dot1dSrPortBridgeNum.access", "read-only"}, {"ibm.nways.bridge.model.Ports.Panel.Dot1dSrPortTargetSegment.access", "read-only"}, {"ibm.nways.bridge.model.Ports.Panel.Dot1dSrPortLargestFrame.access", "read-only"}, {"ibm.nways.bridge.model.Ports.Panel.Dot1dSrPortSTESpanMode.access", "read-only"}, {"ibm.nways.bridge.model.Bridging.Panel.Dot1dStpPriority.access", "read-only"}, {"ibm.nways.bridge.model.Bridging.Panel.Dot1dStpBridgeMaxAge.access", "read-only"}, {"ibm.nways.bridge.model.Bridging.Panel.Dot1dStpBridgeHelloTime.access", "read-only"}, {"ibm.nways.bridge.model.Bridging.Panel.Dot1dStpBridgeForwardDelay.access", "read-only"}, {"ibm.nways.bridge.model.Bridging.Panel.Dot1dTpAgingTime.access", "read-only"}, {"ibm.nways.dlsw.model.DlswCircuit.Panel.DlswCircuitState.access", "read-only"}, {"ibm.nways.dlsw.model.DlswDirMac.Panel.DlswDirMacMac.access", "read-only"}, {"ibm.nways.dlsw.model.DlswDirMac.Panel.DlswDirMacMask.access", "read-only"}, {"ibm.nways.dlsw.model.DlswDirMac.Panel.DlswDirMacEntryType.access", "read-only"}, {"ibm.nways.dlsw.model.DlswDirMac.Panel.DlswDirMacLocationType.access", "read-only"}, {"ibm.nways.dlsw.model.DlswDirMac.Panel.DlswDirMacLocation.access", "read-only"}, {"ibm.nways.dlsw.model.DlswDirMac.Panel.DlswDirMacStatus.access", "read-only"}, {"ibm.nways.dlsw.model.DlswDirMac.Panel.DlswDirMacLFSize.access", "read-only"}, {"ibm.nways.dlsw.model.DlswDirNB.Panel.DlswDirNBName.access", "read-only"}, {"ibm.nways.dlsw.model.DlswDirNB.Panel.DlswDirNBNameType.access", "read-only"}, {"ibm.nways.dlsw.model.DlswDirNB.Panel.DlswDirNBEntryType.access", "read-only"}, {"ibm.nways.dlsw.model.DlswDirNB.Panel.DlswDirNBLocationType.access", "read-only"}, {"ibm.nways.dlsw.model.DlswDirNB.Panel.DlswDirNBLocation.access", "read-only"}, {"ibm.nways.dlsw.model.DlswDirNB.Panel.DlswDirNBStatus.access", "read-only"}, {"ibm.nways.dlsw.model.DlswDirNB.Panel.DlswDirNBLFSize.access", "read-only"}, {"ibm.nways.dlsw.model.DlswIf.Panel.DlswIfVirtualSegment.access", "read-only"}, {"ibm.nways.dlsw.model.DlswIf.Panel.DlswIfSapList.access", "read-only"}, {"ibm.nways.dlsw.model.DlswGenScalars.Panel.DlswNodeStatus.access", "read-only"}, {"ibm.nways.dlsw.model.DlswGenScalars.Panel.DlswNodeVirtualSegLFSize.access", "read-only"}, {"ibm.nways.dlsw.model.DlswGenScalars.Panel.DlswNodeResourceNBExclusivity.access", "read-only"}, {"ibm.nways.dlsw.model.DlswGenScalars.Panel.DlswNodeResourceMacExclusivity.access", "read-only"}, {"ibm.nways.dlsw.model.DlswSdlcLs.Panel.DlswSdlcLsRemoteMac.access", "read-only"}, {"ibm.nways.dlsw.model.DlswSdlcLs.Panel.DlswSdlcLsRemoteSap.access", "read-only"}, {"ibm.nways.dlsw.model.DlswSdlcLs.Panel.DlswSdlcLsLocalMac.access", "read-only"}, {"ibm.nways.dlsw.model.DlswSdlcLs.Panel.DlswSdlcLsLocalSap.access", "read-only"}, {"ibm.nways.dlsw.model.DlswSdlcLs.Panel.DlswSdlcLsLocalIdBlock.access", "read-only"}, {"ibm.nways.dlsw.model.DlswSdlcLs.Panel.DlswSdlcLsLocalIdNum.access", "read-only"}, {"ibm.nways.dlsw.model.DlswTConnConfig.Panel.DlswTConnConfigTDomain.access", "read-only"}, {"ibm.nways.dlsw.model.DlswTConnConfig.Panel.DlswTConnConfigLocalTAddr.access", "read-only"}, {"ibm.nways.dlsw.model.DlswTConnConfig.Panel.DlswTConnConfigRemoteTAddr.access", "read-only"}, {"ibm.nways.dlsw.model.DlswTConnConfig.Panel.DlswTConnConfigEntryType.access", "read-only"}, {"ibm.nways.dlsw.model.DlswTConnConfig.Panel.DlswTConnConfigGroupDefinition.access", "read-only"}, {"ibm.nways.dlsw.model.DlswTConnConfig.Panel.DlswTConnConfigSetupType.access", "read-only"}, {"ibm.nways.dlsw.model.DlswTConnConfig.Panel.DlswTConnConfigSapList.access", "read-only"}, {"ibm.nways.dlsw.model.DlswTConnConfig.Panel.DlswTConnConfigAdvertiseMacNB.access", "read-only"}, {"ibm.nways.dlsw.model.DlswTConnConfig.Panel.DlswTConnConfigInitCirRecvWndw.access", "read-only"}, {"ibm.nways.dlsw.model.DlswTConnOper.Panel.DlswTConnOperState.access", "read-only"}, {"ibm.nways.dlsw.model.DlswTConnTcpConfig.Panel.DlswTConnConfigTDomain.access", "read-only"}, {"ibm.nways.dlsw.model.DlswTConnTcpConfig.Panel.DlswTConnTcpConfigKeepAliveInt.access", "read-only"}, {"ibm.nways.dlsw.model.DlswTConnTcpConfig.Panel.DlswTConnTcpConfigTcpConnections.access", "read-only"}, {"ibm.nways.dlsw.model.DlswTConnTcpConfig.Panel.DlswTConnTcpConfigMaxSegmentSize.access", "read-only"}, {"ibm.nways.dlsw.model.DlswTrapScalars.Panel.DlswTrpCntlTCnnPrtnrRjct.access", "read-only"}, {"ibm.nways.dlsw.model.DlswTrapScalars.Panel.DlswTrapCntlTConnProtViolation.access", "read-only"}, {"ibm.nways.dlsw.model.DlswTrapScalars.Panel.DlswTrapCntlTConn.access", "read-only"}, {"ibm.nways.dlsw.model.DlswTrapScalars.Panel.DlswTrapCntlCircuit.access", "read-only"}, {"ibm.nways.dlsw.model.IbmdlswQllcLs.Panel.IbmdlswQllcLsQaddress.access", "read-only"}, {"ibm.nways.fddi.model.Station.Panel.FddimibSMTStationAction.access", "read-only"}, {"ibm.nways.fddi.model.Port.Panel.FddimibPORTAction.access", "read-only"}, {"ibm.nways.fddi.model.Mac.Panel.FddimibMACRequestedPaths.access", "read-only"}, {"ibm.nways.fddi.model.Mac.Panel.FddimibMACFrameErrorThreshold.access", "read-only"}, {"ibm.nways.fddi.model.Mac.Panel.FddimibMACMAUnitdataEnable.access", "read-only"}, {"ibm.nways.fddi.model.Mac.Panel.FddimibMACNotCopiedThreshold.access", "read-only"}, {"ibm.nways.fddi.model.Port.Panel.FddimibPORTConnectionPolicies.access", "read-only"}, {"ibm.nways.fddi.model.Port.Panel.FddimibPORTRequestedPaths.access", "read-only"}, {"ibm.nways.fddi.model.Port.Panel.FddimibPORTLerCutoff.access", "read-only"}, {"ibm.nways.fddi.model.Port.Panel.FddimibPORTLerAlarm.access", "read-only"}, {"ibm.nways.fddi.model.Station.Panel.FddimibSMTConfigPolicy.access", "read-only"}, {"ibm.nways.fddi.model.Station.Panel.FddimibSMTConnectionPolicy.access", "read-only"}, {"ibm.nways.fddi.model.Station.Panel.FddimibSMTTNotify.access", "read-only"}, {"ibm.nways.fddi.model.Station.Panel.FddimibSMTStatRptPolicy.access", "read-only"}, {"ibm.nways.fddi.model.Station.Panel.FddimibSMTTraceMaxExpiration.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaArpClient.Panel.IpoaArpClientAtmAddr.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaArpSrvr.Panel.IpoaArpSrvrLis.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaConfigPvc.Panel.IpoaConfigPvcDefaultMtu.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaLisIfMapping.Panel.IpoaLisDefaultMtu.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaLisIfMapping.Panel.IpoaLisDefaultEncapsType.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaLisIfMapping.Panel.IpoaLisQDepth.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaLisIfMapping.Panel.IpoaLisMaxCalls.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaLisIfMapping.Panel.IpoaLisRetries.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaLisIfMapping.Panel.IpoaLisDefaultPeakCellRate.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaLisIfMapping.Panel.IpoaLisInactivityTimer.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaLisIfMapping.Panel.IpoaLisMinHoldingTime.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaLisIfMapping.Panel.IpoaLisTimeout.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaLisIfMapping.Panel.IpoaLisCacheEntryAge.access", "read-only"}, {"ibm.nways.ipx.model.General.Panel.IpxBasicSysExistState.access", "read-only"}, {"ibm.nways.ipx.model.General.Panel.IpxBasicSysNetNumber.access", "read-only"}, {"ibm.nways.ipx.model.General.Panel.IpxBasicSysNode.access", "read-only"}, {"ibm.nways.ipx.model.General.Panel.IpxBasicSysName.access", "read-only"}, {"ibm.nways.ipx.model.General.Panel.IpxAdvSysMaxPathSplits.access", "read-only"}, {"ibm.nways.ipx.model.General.Panel.IpxAdvSysMaxHops.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.IpxCircExistState.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.IpxCircOperState.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.IpxCircIfIndex.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.IpxCircName.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.IpxCircType.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.IpxCircDialName.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.IpxCircLocalMaxPacketSize.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.IpxCircCompressState.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.IpxCircCompressSlots.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.IpxCircStaticStatus.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.IpxCircNetNumber.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.RipCircState.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.RipCircPace.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.RipCircUpdate.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.RipCircAgeMultiplier.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.RipCircPacketSize.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.SapCircState.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.SapCircPace.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.SapCircUpdate.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.SapCircAgeMultiplier.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.SapCircPacketSize.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.SapCircGetNearestServerReply.access", "read-only"}, {"ibm.nways.ipx.model.StaticRoutes.Panel.IpxStaticRouteNetNum.access", "read-only"}, {"ibm.nways.ipx.model.StaticRoutes.Panel.IpxStaticRouteCircIndex.access", "read-only"}, {"ibm.nways.ipx.model.StaticRoutes.Panel.IpxStaticRouteExistState.access", "read-only"}, {"ibm.nways.ipx.model.StaticRoutes.Panel.IpxStaticRouteTicks.access", "read-only"}, {"ibm.nways.ipx.model.StaticRoutes.Panel.IpxStaticRouteHopCount.access", "read-only"}, {"ibm.nways.ipx.model.StaticRoutes.Panel.IpxStaticRouteSysInstance.access", "read-only"}, {"ibm.nways.ipx.model.StaticServ.Panel.IpxStaticServSysInstance.access", "read-only"}, {"ibm.nways.ipx.model.StaticServ.Panel.IpxStaticServCircIndex.access", "read-only"}, {"ibm.nways.ipx.model.StaticServ.Panel.IpxStaticServName.access", "read-only"}, {"ibm.nways.ipx.model.StaticServ.Panel.IpxStaticServType.access", "read-only"}, {"ibm.nways.ipx.model.StaticServ.Panel.IpxStaticServExistState.access", "read-only"}, {"ibm.nways.ipx.model.StaticServ.Panel.IpxStaticServNetNum.access", "read-only"}, {"ibm.nways.ipx.model.StaticServ.Panel.IpxStaticServNode.access", "read-only"}, {"ibm.nways.ipx.model.StaticServ.Panel.IpxStaticServSocket.access", "read-only"}, {"ibm.nways.ipx.model.StaticServ.Panel.IpxStaticServHopCount.access", "read-only"}, {"ibm.nways.lane.model.BusLec.Panel.BusLecMcastSendAtmIfIndex.access", "read-only"}, {"ibm.nways.lane.model.BusLec.Panel.BusLecMcastSendVpi.access", "read-only"}, {"ibm.nways.lane.model.BusLec.Panel.BusLecMcastSendVci.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecConfigMode.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecConfigLesAtmAddress.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecConfigLanName.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecConfigLanType.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecConfigMaxDataFrameSize.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecControlTimeout.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecMaxUnknownFrameCount.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecMaxUnknownFrameTime.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecVccTimeoutPeriod.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecMaxRetryCount.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecAgingTime.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecForwardDelayTime.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecExpectedArpResponseTime.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecFlushTimeOut.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecPathSwitchingDelay.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecMulticastSendType.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecMulticastSendAvgRate.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecMulticastSendPeakRate.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecConnectionCompleteTimer.access", "read-only"}, {"ibm.nways.llc.model.LlcCcOper.Panel.LlcCcOperMaxIPDUOctetsSend.access", "read-only"}, {"ibm.nways.llc.model.LlcCcOper.Panel.LlcCcOperMaxUnackedIPDUsSend.access", "read-only"}, {"ibm.nways.llc.model.LlcCcOper.Panel.LlcCcOperMaxUnackedIPDUsRcv.access", "read-only"}, {"ibm.nways.llc.model.LlcCcOper.Panel.LlcCcOperMaxRetransmits.access", "read-only"}, {"ibm.nways.llc.model.LlcCcOper.Panel.LlcCcOperAckTimer.access", "read-only"}, {"ibm.nways.llc.model.LlcCcOper.Panel.LlcCcOperInactTimer.access", "read-only"}, {"ibm.nways.llc.model.LlcCcOper.Panel.LlcCcOperDelayAckCount.access", "read-only"}, {"ibm.nways.llc.model.LlcCcOper.Panel.LlcCcOperDelayAckTimer.access", "read-only"}, {"ibm.nways.llc.model.LlcPorts.Panel.LlcPortAdminName.access", "read-only"}, {"ibm.nways.llc.model.LlcPorts.Panel.LlcPortAdminMaxIPDUOctetsSend.access", "read-only"}, {"ibm.nways.llc.model.LlcPorts.Panel.LlcPortAdminMaxUnackedIPDUsSend.access", "read-only"}, {"ibm.nways.llc.model.LlcPorts.Panel.LlcPortAdminMaxUnackedIPDUsRcv.access", "read-only"}, {"ibm.nways.llc.model.LlcPorts.Panel.LlcPortAdminMaxRetransmits.access", "read-only"}, {"ibm.nways.llc.model.LlcPorts.Panel.LlcPortAdminAckTimer.access", "read-only"}, {"ibm.nways.llc.model.LlcPorts.Panel.LlcPortAdminInactTimer.access", "read-only"}, {"ibm.nways.llc.model.LlcPorts.Panel.LlcPortAdminDelayAckCount.access", "read-only"}, {"ibm.nways.llc.model.LlcPorts.Panel.LlcPortAdminDelayAckTimer.access", "read-only"}, {"ibm.nways.llc.model.LlcSaps.Panel.LlcSapAdminMaxIPDUOctetsSend.access", "read-only"}, {"ibm.nways.llc.model.LlcSaps.Panel.LlcSapAdminMaxUnackedIPDUsSend.access", "read-only"}, {"ibm.nways.llc.model.LlcSaps.Panel.LlcSapAdminMaxUnackedIPDUsRcv.access", "read-only"}, {"ibm.nways.llc.model.LlcSaps.Panel.LlcSapAdminMaxRetransmits.access", "read-only"}, {"ibm.nways.llc.model.LlcSaps.Panel.LlcSapAdminAckTimer.access", "read-only"}, {"ibm.nways.llc.model.LlcSaps.Panel.LlcSapAdminInactTimer.access", "read-only"}, {"ibm.nways.llc.model.LlcSaps.Panel.LlcSapAdminDelayAckCount.access", "read-only"}, {"ibm.nways.llc.model.LlcSaps.Panel.LlcSapAdminDelayAckTimer.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteDest.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteIfIndex.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric1.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric2.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric3.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric4.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric5.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteNextHop.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteType.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteAge.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMask.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteType.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaIfIndex.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaNetAddress.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaPhysAddress.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaType.access", "read-only"}, {"ibm.nways.mib2.model.IpParam.Panel.IpForwarding.access", "read-only"}, {"ibm.nways.mib2.model.IpParam.Panel.IpDefaultTTL.access", "read-only"}, {"ibm.nways.mib2.model.Interface.Panel.IfPromiscuousMode.access", "read-only"}, {"ibm.nways.mib2.model.Interface.Panel.IfLinkUpDownTrapEnable.access", "read-only"}, {"ibm.nways.mib2.model.System.Panel.SysContact.length", "78"}, {"ibm.nways.mib2.model.System.Panel.SysName.length", "78"}, {"ibm.nways.mib2.model.System.Panel.SysLocation.length", "78"}, {"ibm.nways.ospf.model.Area.Panel.OspfAuthType.access", "read-only"}, {"ibm.nways.ospf.model.Area.Panel.OspfImportASExtern.access", "read-only"}, {"ibm.nways.ospf.model.AreaRange.Panel.OspfAreaRangeAreaID.access", "read-only"}, {"ibm.nways.ospf.model.AreaRange.Panel.OspfAreaRangeNet.access", "read-only"}, {"ibm.nways.ospf.model.AreaRange.Panel.OspfAreaRangeMask.access", "read-only"}, {"ibm.nways.ospf.model.AreaRange.Panel.OspfAreaRangeStatus.access", "read-only"}, {"ibm.nways.ospf.model.General.Panel.OspfRouterId.access", "read-only"}, {"ibm.nways.ospf.model.General.Panel.OspfAdminStat.access", "read-only"}, {"ibm.nways.ospf.model.General.Panel.OspfASBdrRtrStatus.access", "read-only"}, {"ibm.nways.ospf.model.General.Panel.OspfTOSSupport.access", "read-only"}, {"ibm.nways.ospf.model.Host.Panel.OspfHostIpAddress.access", "read-only"}, {"ibm.nways.ospf.model.Host.Panel.OspfHostMetric.access", "read-only"}, {"ibm.nways.ospf.model.Host.Panel.OspfHostStatus.access", "read-only"}, {"ibm.nways.ospf.model.Interfaces.Panel.OspfIfIpAddress.access", "read-only"}, {"ibm.nways.ospf.model.Interfaces.Panel.OspfAddressLessIf.access", "read-only"}, {"ibm.nways.ospf.model.Interfaces.Panel.OspfIfAreaId.access", "read-only"}, {"ibm.nways.ospf.model.Interfaces.Panel.OspfIfType.access", "read-only"}, {"ibm.nways.ospf.model.Interfaces.Panel.OspfIfAdminStat.access", "read-only"}, {"ibm.nways.ospf.model.Interfaces.Panel.OspfIfRtrPriority.access", "read-only"}, {"ibm.nways.ospf.model.Interfaces.Panel.OspfIfTransitDelay.access", "read-only"}, {"ibm.nways.ospf.model.Interfaces.Panel.OspfIfRetransInterval.access", "read-only"}, {"ibm.nways.ospf.model.Interfaces.Panel.OspfIfHelloInterval.access", "read-only"}, {"ibm.nways.ospf.model.Interfaces.Panel.OspfIfRtrDeadInterval.access", "read-only"}, {"ibm.nways.ospf.model.Interfaces.Panel.OspfIfPollInterval.access", "read-only"}, {"ibm.nways.ospf.model.Neighbor.Panel.OspfNbrIpAddr.access", "read-only"}, {"ibm.nways.ospf.model.Neighbor.Panel.OspfNbrAddressLessIndex.access", "read-only"}, {"ibm.nways.ospf.model.Neighbor.Panel.OspfNbrPriority.access", "read-only"}, {"ibm.nways.vlan.model.IbmVlan.Panel.IbmVlanAdminStatus.access", "read-only"}, {"ibm.nways.vlan.model.IbmVlan.Panel.IbmVlanConfBridgeId.access", "read-only"}, {"ibm.nways.vlan.model.IbmVlan.Panel.IbmVlanConfType.access", "read-only"}, {"ibm.nways.vlan.model.IbmVlan.Panel.IbmVlanConfAgingTimer.access", "read-only"}, {"ibm.nways.vlan.model.IbmVlan.Panel.IbmVlanConfName.access", "read-only"}, {"ibm.nways.vlan.model.IbmVlan.Panel.IbmVlanConfRowStatus.access", "read-only"}, {"ibm.nways.vlan.model.IbmVlan.Panel.IbmVlanIpNetworkAddr.access", "read-only"}, {"ibm.nways.vlan.model.IbmVlan.Panel.IbmVlanIpNetworkMask.access", "read-only"}, {"ibm.nways.vlan.model.IbmVlan.Panel.IbmVlanIpCutThruFromHere.access", "read-only"}, {"ibm.nways.vlan.model.IbmVlan.Panel.IbmVlanIpCutThruToHere.access", "read-only"}, {"ibm.nways.vlan.model.IbmVlan.Panel.IbmVlanIpxNetworkAddr.access", "read-only"}, {"ibm.nways.vlan.model.IbmVlan.Panel.IbmVlanUDSWOffsetType.access", "read-only"}, {"ibm.nways.vlan.model.IbmVlan.Panel.IbmVlanUDSWOffset.access", "read-only"}, {"ibm.nways.vlan.model.IbmVlan.Panel.IbmVlanUDSWMask.access", "read-only"}, {"ibm.nways.vlan.model.IbmVlan.Panel.IbmVlanUDSWFilter.access", "read-only"}, {"ibm.nways.vlan.model.IbmVlan.Panel.IbmVlanConfIncludedPortMap.access", "read-only"}, {"ibm.nways.vlan.model.IbmVlan.Panel.IbmVlanConfExcludedPortMap.access", "read-only"}, {"ibm.nways.superelan.model.IbmSEBridge.Panel.IbmSEAtmIfNumber.access", "read-only"}, {"ibm.nways.superelan.model.IbmSEBridge.Panel.IbmSEEnabled.access", "read-only"}, {"ibm.nways.superelan.model.IbmSEBridge.Panel.IbmSEName.access", "read-only"}, {"ibm.nways.superelan.model.IbmSEBridge.Panel.IbmSEFrameSize.access", "read-only"}, {"ibm.nways.superelan.model.IbmSEBridge.Panel.IbmSEMacCacheAge.access", "read-only"}, {"ibm.nways.superelan.model.IbmSEBridge.Panel.IbmSERDCacheAge.access", "read-only"}, {"ibm.nways.superelan.model.IbmSEBridge.Panel.IbmSEPriority.access", "read-only"}, {"ibm.nways.superelan.model.IbmSEBridge.Panel.IbmSEMaxAge.access", "read-only"}, {"ibm.nways.superelan.model.IbmSEBridge.Panel.IbmSEBridgeHelloTime.access", "read-only"}, {"ibm.nways.superelan.model.IbmSEBridge.Panel.IbmSEBridgeForwardDelay.access", "read-only"}, {"ibm.nways.superelan.model.IbmSEBridge.Panel.IbmSEBridgeAddress.access", "read-only"}, {"ibm.nways.superelan.model.IbmSEBridge.Panel.IbmSEType.access", "read-only"}, {"ibm.nways.superelan.model.IbmSEBridge.Panel.IbmSEConfigRowStatus.access", "read-only"}, {"ibm.nways.superelan.model.IbmSEPort.Panel.IbmSEPortElanName.access", "read-only"}, {"ibm.nways.superelan.model.IbmSEPort.Panel.IbmSEPortRemoteElan.access", "read-only"}, {"ibm.nways.superelan.model.IbmSEPort.Panel.IbmSEPortEnabled.access", "read-only"}, {"ibm.nways.superelan.model.IbmSEPort.Panel.IbmSEPortRootCost.access", "read-only"}, {"ibm.nways.superelan.model.IbmSEPort.Panel.IbmSEPortRowStatus.access", "read-only"}, {"ibm.nways.appn.model.SnaNodeAdmin.Panel.SnaNodeAdminName.access", "read-only"}, {"ibm.nways.appn.model.SnaNodeAdmin.Panel.SnaNodeAdminBlockNum.access", "read-only"}, {"ibm.nways.appn.model.SnaNodeAdmin.Panel.SnaNodeAdminIdNum.access", "read-only"}, {"ibm.nways.appn.model.SnaNodeAdmin.Panel.SnaNodeAdminState.access", "read-only"}, {"ibm.nways.appn.model.SnaNodeAdmin.Panel.SnaNodeAdminType.access", "read-only"}, {"ibm.nways.appn.model.SnaNodeAdmin.Panel.SnaNodeAdminXidFormat.access", "read-only"}, {"ibm.nways.appn.model.SnaNodeAdmin.Panel.SnaNodeAdminEnablingMethod.access", "read-only"}, {"ibm.nways.appn.model.SnaNodeAdmin.Panel.SnaNodeAdminLuTermDefault.access", "read-only"}, {"ibm.nways.appn.model.SnaNodeAdmin.Panel.SnaNodeAdminMaxLu.access", "read-only"}, {"ibm.nways.appn.model.SnaNodeAdmin.Panel.SnaNodeAdminHostDescription.access", "read-only"}, {"ibm.nways.appn.model.SnaNodeAdmin.Panel.SnaNodeAdminStopMethod.access", "read-only"}, {"ibm.nways.appn.model.SnaNodeLinkAdmin.Panel.SnaNodeLinkAdminMaxPiu.access", "read-only"}, {"ibm.nways.appn.model.SnaLuAdmin.Panel.SnaLuAdminName.access", "read-only"}, {"ibm.nways.appn.model.SnaLuAdmin.Panel.SnaLuOperSnaName.access", "read-only"}, {"ibm.nways.appn.model.SnaLuAdmin.Panel.SnaLuAdminSnaName.access", "read-only"}, {"ibm.nways.appn.model.SnaLuAdmin.Panel.SnaLuOperType.access", "read-only"}, {"ibm.nways.appn.model.SnaLuAdmin.Panel.SnaLuAdminType.access", "read-only"}, {"ibm.nways.appn.model.SnaLuAdmin.Panel.SnaLuAdminDepType.access", "read-only"}, {"ibm.nways.appn.model.SnaLuAdmin.Panel.SnaLuAdminLocalAddress.access", "read-only"}, {"ibm.nways.appn.model.SnaLuAdmin.Panel.SnaLuAdminTerm.access", "read-only"}, {"ibm.nways.appn.model.SnaLuAdmin.Panel.SnaLuAdminDisplayModel.access", "read-only"}, {"ibm.nways.mpoa.model.MpcMapping.Panel.MpcMappingRowStatus.access", "read-only"}, {"ibm.nways.mpoa.model.MpcMapping.Panel.MpcMappingIndex.access", "read-only"}};

    public GraphicPanel getDeviceGraphicPanel() {
        this.displayMsg(this.mssBundle.getString("startGraphic"));
        this.mssModel = (GenModel)this.getModel();
        GraphicPanel graphicPanel = null;
        if (RAS.isEnabled(19, 26)) {
            RAS.trace(19, 26, (Object)this, "getDeviceGraphicPanel()", "isBox = " + this.isBox + "isBlade = " + this.isBlade + "isDeviceUP = " + this.isDeviceUp);
        }
        if (this.isDeviceUp) {
            if (this.isBox) {
                BoxGraphic boxGraphic = new BoxGraphic(this);
                if (this.isV2MSS) {
                    boxGraphic.setMSSV2(this.isV2MSS);
                }
                boxGraphic.setMssModel(this.mssModel);
                graphicPanel = boxGraphic.getGraphicPanel();
            } else if (this.isBlade) {
                BladeGraphic bladeGraphic = new BladeGraphic(this);
                bladeGraphic.setMssModel(this.mssModel);
                if (this.isSSBlade) {
                    bladeGraphic.setSSBlade(this.isBlade);
                }
                graphicPanel = bladeGraphic.getGraphicPanel();
            }
        }
        this.displayMsg(this.mssBundle.getString("endGraphic"));
        return graphicPanel;
    }

    public NavigationPoint getNavTreeRoot() {
        if (RAS.isEnabled(19, 26)) {
            RAS.trace(19, 26, (Object)this, "getNavTreeRoot()", "Nav Root");
        }
        this.mssBundle = ResourceBundle.getBundle("ibm.nways.mss.Resources");
        this.displayMsg(this.mssBundle.getString("createNav"));
        this.getInitialBoxInfo();
        Object object = !this.isDeviceUp ? new NavigationFolder(this.mssBundle.getString("UNKNOWN")) : new MssFolderGroup((JdmBrowser)this, this.mssModel);
        NavigationContext navigationContext = object.getNavContext();
        this.mssOverrides = new NavFieldOverride(navigationContext, mssFieldOverrides);
        navigationContext.put((Object)"codeLevel", (Object)this.codeLevel);
        if (RAS.isEnabled(19, 26)) {
            RAS.trace(19, 26, (Object)this, "getNavTreeRoot()", "MSS CodeLevel = " + this.codeLevel.toString());
        }
        return object;
    }

    public void getRestOfNavTree() {
        NavigationFolder navigationFolder = (NavigationFolder)this.getNavigationTree();
        this.tree = this.getNavigationBrowser();
        NavigationContext navigationContext = navigationFolder.getNavContext();
        navigationContext.put((Object)"TREE", (Object)this.tree);
        NavigationFolder navigationFolder2 = (NavigationFolder)this.getNavigationTree();
        this.buildConfigurationFolder(navigationFolder2);
        this.buildFaultFolder(navigationFolder2);
        this.buildToolsFolder(navigationFolder2);
        this.displayMsg(this.mssBundle.getString("done"));
    }

    private void buildConfigurationFolder(NavigationFolder navigationFolder) {
        block8: {
            try {
                GenModel genModel = (GenModel)this.mssModel.getComponent("ConfigurationFolder");
                if (RAS.isEnabled(19, 26)) {
                    RAS.trace(19, 26, (Object)this, "buildConfigurationFolder()", "building configuration folder");
                }
                if (!this.isDeviceUp || genModel == null) {
                    GenModel genModel2 = null;
                    try {
                        genModel2 = (GenModel)this.mssModel.getComponent("System");
                        if (RAS.isEnabled(19, 26)) {
                            RAS.trace(19, 26, (Object)this, "buildConfigurationFolder()", "Got System Model = " + genModel2);
                        }
                    }
                    catch (Exception exception) {
                        RAS.logException(19, 26, (Object)this, "buildConfigurationFolder()", exception);
                    }
                    if (genModel2 != null) {
                        SystemGeneralGroup systemGeneralGroup = new SystemGeneralGroup((JdmBrowser)this, genModel2);
                        systemGeneralGroup.setIsInitiallyExpanded(false);
                        this.tree.addEventListener((NavigationBrowserEventListener)systemGeneralGroup);
                        navigationFolder.add((NavigationPoint)systemGeneralGroup);
                        return;
                    }
                    break block8;
                }
                ConfigurationFolderGroup configurationFolderGroup = new ConfigurationFolderGroup((JdmBrowser)this, genModel);
                configurationFolderGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener((NavigationBrowserEventListener)configurationFolderGroup);
                navigationFolder.add((NavigationPoint)configurationFolderGroup);
                return;
            }
            catch (Exception exception) {
                RAS.logException(19, 26, (Object)this, "buildConfigurationFolder()", exception);
            }
        }
    }

    private void buildFaultFolder(NavigationFolder navigationFolder) {
        try {
            GenModel genModel = (GenModel)this.mssModel.getComponent("Traps");
            if (RAS.isEnabled(19, 26)) {
                RAS.trace(19, 26, (Object)this, "buildFaultFolder()", "Got Traps");
            }
            FaultGroup faultGroup = new FaultGroup((JdmBrowser)this, this.mssModel);
            faultGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)faultGroup);
            navigationFolder.add((NavigationPoint)faultGroup);
            return;
        }
        catch (Exception exception) {
            RAS.logException(19, 26, (Object)this, "buildFaultFolder()", exception);
            return;
        }
    }

    private void buildToolsFolder(NavigationFolder navigationFolder) {
        AnalyzerJdmContext analyzerJdmContext;
        NavigationContext navigationContext;
        Object object;
        Object object2;
        Object object3;
        String string;
        Object object4;
        SnmpContextModel snmpContextModel;
        NavigationFolder navigationFolder2 = new NavigationFolder(this.mssBundle.getString("tools"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
        navigationFolder.add((NavigationPoint)navigationFolder2);
        try {
            snmpContextModel = (SnmpContextModel)this.mssModel.getComponent("_ContextInfo");
            object4 = snmpContextModel.getConfig();
            string = ((ModelInfo)object4).get("Config.Address").toString();
            object3 = ResourceBundle.getBundle("ibm.nways.telnet.TelnetPanelResources");
            object2 = new TelnetContext(string);
            object = new NavigationItem(((ResourceBundle)object3).getString("TelnetPanelTitle"), new NavigationDestination("ibm.nways.telnet.TelnetPanel", null), "Telnet");
            navigationContext = object.getNavContext();
            navigationContext.put((Object)"telnetContext", object2);
            navigationFolder2.add((NavigationPoint)object);
            if (this.getIsApplication()) {
                analyzerJdmContext = new AnalyzerJdmContext(string, this.getServerPortNumber());
                NavigationItem navigationItem = new NavigationItem(AnalyzerJdmPanel.getTitle(), new NavigationDestination("ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel", null), "Analyzer");
                navigationContext = navigationItem.getNavContext();
                navigationContext.put((Object)"analyzerJdmContext", (Object)analyzerJdmContext);
                navigationFolder2.add((NavigationPoint)navigationItem);
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 26, (Object)this, "buildToolsFolder()", exception);
        }
        object4 = System.getProperty("os.name");
        if (this.getIsApplication() && (((String)object4).equals("Windows NT") || ((String)object4).equals("AIX"))) {
            object3 = CfgToolContext.autoDetect((String)"MSS", (int)this.codeLevel.version, (int)this.codeLevel.release, (int)this.codeLevel.maintenance);
            if (object3 == null) {
                object3 = this.codeLevel.atLevel(1, 0, 0, 0) ? new CfgToolContext("MSS_V1R1") : (this.codeLevel.atLevelWithPTF(1, 0, 0, 1) ? new CfgToolContext("MSS_V1R1_0_PTF1") : (this.codeLevel.atLevelWithPTF(1, 1, 0, 0) || this.codeLevel.atLevelWithPTF(1, 1, 1, 0) ? new CfgToolContext("MSS_V1R1_1") : (this.codeLevel.atLevelWithPTF(2, 0, 0, 0) ? new CfgToolContext("MSS_V2R0") : (this.codeLevel.atLevelWithPTF(2, 0, 1, 0) ? new CfgToolContext("MSS_V2R0_1") : (this.codeLevel.atLevelWithPTF(2, 1, 0, 0) || this.codeLevel.atLevelWithPTF(2, 1, 0, 0) ? new CfgToolContext("MSS_V2R1") : new CfgToolContext("MSS_DEFAULT"))))));
            }
            object2 = ResourceBundle.getBundle("ibm.nways.cfgtool.CfgToolGroupResources");
            object = new NavigationItem(((ResourceBundle)object2).getString("cfgtoolPanelTitle"), new NavigationDestination("ibm.nways.cfgtool.CfgToolPanel", null), "CfgTool");
            navigationContext = object.getNavContext();
            navigationContext.put((Object)"cfgtoolContext", object3);
            navigationFolder2.add((NavigationPoint)object);
        }
        try {
            object3 = this.getNavigationBrowser();
            snmpContextModel = (SnmpContextModel)this.mssModel.getComponent("_ContextInfo");
            object2 = new Browser("MIB Browser", (JdmBrowser)this, snmpContextModel);
            object3.addEventListener((NavigationBrowserEventListener)object2);
            navigationFolder2.add((NavigationPoint)object2.getRootFolder());
        }
        catch (Exception exception) {
            RAS.logException(19, 26, (Object)this, "buildToolsFolder()", exception);
        }
        try {
            snmpContextModel = (SnmpContextModel)this.mssModel.getComponent("_ContextInfo");
            object3 = snmpContextModel.getConfig();
            string = ((ModelInfo)object3).get("Config.Address").toString();
            object2 = new WebContext(string);
            if (RAS.isEnabled(19, 26)) {
                RAS.trace(19, 26, (Object)this, "buildToolsFolder()", "codeLevel = " + this.codeLevel.toString());
            }
            if (this.codeLevel.atLevelWithPTF(1, 0, 0, 0)) {
                if (RAS.isEnabled(19, 26)) {
                    RAS.trace(19, 26, (Object)this, "buildToolsFolder()", "in 1.0 case");
                }
                object2.v1Device();
                object2.remove_appletalk();
                object2.remove_nhrp();
                object2.remove_vines();
                object2.remove_scsp();
                object2.remove_mars();
                object2.remove_se();
            } else if (this.codeLevel.atLevelWithPTF(1, 1, 0, 0) || this.codeLevel.atLevelWithPTF(1, 1, 1, 0)) {
                if (RAS.isEnabled(19, 26)) {
                    RAS.trace(19, 26, (Object)this, "buildToolsFolder()", "in 1.1 case");
                }
                object2.v1Device();
                object2.remove_vines();
                object2.remove_scsp();
                object2.remove_mars();
                object2.remove_se();
            } else if (this.codeLevel.atLevelWithPTF(2, 1, 0, 0)) {
                if (RAS.isEnabled(19, 26)) {
                    RAS.trace(19, 26, (Object)this, "buildToolsFolder()", "in 2.1 case");
                }
                object2.remove_nhrp();
                object2.add_nhrp_v21();
                object2.remove_dvmrp();
                object2.add_dvmrp_v21();
                object2.add_mpoa();
                object2.add_dlsw();
            }
            object = ResourceBundle.getBundle("ibm.nways.web.Resources");
            analyzerJdmContext = new NavigationItem(((ResourceBundle)object).getString("weblaunch"), new NavigationDestination("ibm.nways.web.WebBrowserPanel", null), "WebBrowser");
            navigationContext = analyzerJdmContext.getNavContext();
            navigationContext.put((Object)"webContext", object2);
            navigationFolder2.add((NavigationPoint)analyzerJdmContext);
        }
        catch (Exception exception) {
            RAS.logException(19, 26, (Object)this, "buildToolsFolder()", exception);
        }
        try {
            object3 = (GenModel)this.mssModel.getComponent("Rping");
            object2 = new NavigationItem(RpingBasePanel.getTitle(), new NavigationDestination("ibm.nways.rping.RpingPanel", (RemoteModel)object3), "Rping");
            navigationFolder2.add((NavigationPoint)object2);
            return;
        }
        catch (Exception exception) {
            RAS.logException(19, 26, (Object)this, "buildToolsFolder()", exception);
            return;
        }
    }

    private void getInitialBoxInfo() {
        try {
            this.mssModel = (GenModel)this.getModel();
            ModelInfo modelInfo = this.mssModel.getInfo("Config");
            this.checkRelease(modelInfo);
            if (RAS.isEnabled(19, 26)) {
                RAS.trace(19, 26, (Object)this, "getInitialBoxInfo()", "Got MSS ModelImpl");
                return;
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 26, (Object)this, "getInitialBoxInfo()", exception);
            this.isDeviceUp = false;
            this.isBox = false;
            this.isBlade = false;
        }
    }

    public String getModelTypeName() {
        return "ibm.nways.mss.model.Mss";
    }

    public void checkRelease(ModelInfo modelInfo) {
        OID oID = new OID(".1.3.6.1.4.1.2.6.118.2");
        OID oID2 = new OID(".1.3.6.1.4.1.2.6.118.3");
        Serializable serializable = modelInfo.get("Config.SysObjectID");
        if (serializable instanceof Timeout || serializable instanceof NotSupported) {
            if (RAS.isEnabled(19, 26)) {
                RAS.trace(19, 26, (Object)this, "checkRelease()", "Can't talk to the Device" + serializable.toString());
            }
            this.isDeviceUp = false;
            this.isBox = false;
            this.isBlade = false;
            new BoxDownMsg(this.getFrame(), this.mssBundle.getString("MSSJDM"));
            return;
        }
        String string = serializable.toString();
        if (RAS.isEnabled(19, 26)) {
            RAS.trace(19, 26, (Object)this, "checkRelease()", "sysOid = " + string);
        }
        OID oID3 = new OID(string);
        this.isBox = oID.equals(oID3);
        if (RAS.isEnabled(19, 26)) {
            RAS.trace(19, 26, (Object)this, "checkRelease()", "isBox = " + this.isBox + "Box sysOid = " + oID);
        }
        this.isBlade = oID2.equals(oID3);
        if (!this.isBlade && !this.isBox) {
            new WrongSysOidMsg(this.getFrame(), this.mssBundle.getString("MSSJDM"));
        } else {
            String string2 = modelInfo.get("Config.SysDescr").toString();
            this.codeLevel = new CodeLevelMss(string2);
            if (RAS.isEnabled(19, 26)) {
                RAS.trace(19, 26, (Object)this, "checkRelease()", "sysDescr = " + string2 + "codeLevel = " + this.codeLevel.toString());
            }
            try {
                Integer n = (Integer)modelInfo.get("Config.PlatformType");
                if (RAS.isEnabled(19, 26)) {
                    RAS.trace(19, 26, (Object)this, "checkRelease()", "Platform Type = " + n);
                }
                if (n == 26) {
                    this.isSSBlade = true;
                }
                if (n == 25) {
                    this.isV2MSS = true;
                }
            }
            catch (Exception exception) {
                RAS.logException(19, 26, (Object)this, "checkRelease()", exception);
            }
        }
        this.isDeviceUp = true;
    }

    public void dispose() {
        this.codeLevel = null;
        this.mssModel = null;
        this.mssBundle = null;
        this.mssOverrides = null;
        this.tree = null;
        super.dispose();
    }
}

